﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Entities;
using CashierCrisis.Core;

namespace CashierCrisis.Behaviors
{
    public class FollowPlayer : Action
    {
        public Entity Player { get; set; }
        public float FollowDistance { get; set; }
        public SteeringComponent steering;

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            steering = Entity.GetComponent("steering") as SteeringComponent;

            if (!Entity.Position.Close(Player.Position, 0.9f))
            {
                steering.TargetEntity = Player;
                steering.ToggleSteeringBehavior(SteeringBehavior.Arrive, true);
            }
            else
            {
                steering.ToggleSteeringBehavior(SteeringBehavior.Arrive, false);
            }

            return Running;
        }

    }
}
